% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTreePlotter.R
\docType{methods}
\name{trackBTree}
\alias{trackBTree}
\alias{trackBTree,BTreePlotter-method}
\alias{trackBTree}
\title{trackBTree}
\usage{
trackBTree(.Object, rbd1, rbd2, is.matched = FALSE, min.srcSize = 0.5,
  min.trtSize = 0.1, min.overlap = 1e+05)

\S4method{trackBTree}{BTreePlotter}(.Object, rbd1, rbd2, is.matched = FALSE,
  min.srcSize = 0.5, min.trtSize = 0.1, min.overlap = 1e+05)
}
\arguments{
\item{.Object}{the object}

\item{rbd1}{rbd one}

\item{rbd2}{rbd two}

\item{is.matched}{is it matched}

\item{min.srcSize}{min src size}

\item{min.trtSize}{min trt size}

\item{min.overlap}{min overlap}
}
\value{
geom_segment location of BTree track
}
\description{
get the geom_segment location of the BTree track
}
\examples{

load(system.file("data", "allCall.lst.RData", package="BubbleTree"))

btreeplotter <- new("BTreePlotter", max.ploidy=5, max.size=10)
nn <- "sam2"
rbd1 <- allCall.lst[[nn]]@rbd
rbd2 <- allCall.lst[[nn]]@rbd.adj
arrows <- trackBTree(btreeplotter, rbd1, rbd2, min.srcSize=0.01, 
                     min.trtSize=0.01)
btree <- drawBTree(btreeplotter, rbd1) + 
    drawBubbles(btreeplotter, rbd2, "gray80") + arrows
}
