% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTreePredictor.R
\docType{methods}
\name{loadRBD}
\alias{loadRBD}
\alias{loadRBD,BTreePredictor-method}
\alias{loadRBD}
\title{loadRBD}
\usage{
loadRBD(.Object, rbd, total.mark = NA)

\S4method{loadRBD}{BTreePredictor}(.Object, rbd, total.mark = NA)
}
\arguments{
\item{.Object}{the object}

\item{rbd}{rbd object}

\item{total.mark}{total mark}
}
\value{
.Object populated with the RBD list with updated segment size
}
\description{
load the RBD data
}
\examples{

load(system.file("data", "allRBD.lst.RData", package="BubbleTree"))

btreepredictor <- new("BTreePredictor")
btreepredictor@config$cutree.h <- 0.15

high.ploidy <- rep(TRUE, length(allRBD.lst))
high.purity <- rep(TRUE, length(allRBD.lst))

high.ploidy[c("sam6",
              "ovary.wgs",
              "ovary.wes",
              "TCGA-06-0145-01A-01W-0224-08",
              "TCGA-13-1500-01A-01D-0472-01",
              "TCGA-AO-A0JJ-01A-11W-A071-09")] <- FALSE

high.purity[c("sam6", "ovary.wgs", "ovary.wes")] <- FALSE

nn <- "sam6"

rbd <- allRBD.lst[[nn]]
btreepredictor@config$high.ploidy <- high.ploidy[nn]
btreepredictor@config$high.purity <- high.purity[nn]
btreepredictor <- loadRBD(btreepredictor, rbd)
}
