% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrackPlotter.R
\docType{methods}
\name{heteroLociTrack}
\alias{heteroLociTrack}
\alias{heteroLociTrack,TrackPlotter-method}
\alias{heteroLociTrack}
\title{heteroLociTrack}
\usage{
heteroLociTrack(.Object, result.dat, gr2, hetero.gr = NULL, min.prev = 0.15,
  ymax = 4.3, cex = 0.5)

\S4method{heteroLociTrack}{TrackPlotter}(.Object, result.dat, gr2,
  hetero.gr = NULL, min.prev = 0.15, ymax = 4.3, cex = 0.5)
}
\arguments{
\item{.Object}{the object}

\item{result.dat}{the results}

\item{gr2}{the gr2 object}

\item{hetero.gr}{hetero annotation}

\item{min.prev}{previous min}

\item{ymax}{max y}

\item{cex}{the cex}
}
\value{
the highlightted heterozygosity track
}
\description{
get the heteroLoci track
}
\examples{

load(system.file("data", "allCall.lst.RData", package="BubbleTree"))
load(system.file("data", "centromere.dat.rda", package="BubbleTree"))
load(system.file("data", "allHetero.lst.RData", package="BubbleTree"))
load(system.file("data", "hg19.seqinfo.rda", package="BubbleTree"))


trackplotter <- new("TrackPlotter")
gr2 = centromere.dat
nn <- "sam2"
z1 <- heteroLociTrack(trackplotter, allCall.lst[[nn]]@result, 
                      gr2, allHetero.lst[[nn]])
}
