% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrackPlotter.R
\name{getTracks}
\alias{getTracks}
\title{getTracks}
\usage{
getTracks(p1, p2, title = "")
}
\arguments{
\item{p1}{set 1}

\item{p2}{set 2}

\item{title}{the title}
}
\value{
all of the requested tracks
}
\description{
get all tracks
}
\examples{

load(system.file("data", "allCall.lst.RData", package="BubbleTree"))
load(system.file("data", "centromere.dat.rda", package="BubbleTree"))
load(system.file("data", "all.somatic.lst.RData", package="BubbleTree"))
load(system.file("data", "hg19.seqinfo.rda", package="BubbleTree"))

trackplotter <- new("TrackPlotter")
gr2 = centromere.dat
nn <- "sam2"
ymax <- ifelse(nn \%in\% c("lung.wgs", "lung.wes"), 9, 4.3)
p1 <- xyTrack(trackplotter,
              result.dat=allCall.lst[[nn]]@result,
              gr2=gr2,
              ymax=ymax) + ggplot2::labs(title=nn)

p2 <- bafTrack(trackplotter,
               result.dat=allCall.lst[[nn]]@result,
               gr2=gr2,
               somatic.gr=all.somatic.lst[[nn]])

t1 <- getTracks(p1, p2)
}
