% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTreePlotter.R
\docType{methods}
\name{drawFeatures}
\alias{drawFeatures}
\alias{drawFeatures,BTreePlotter-method}
\alias{drawFeatures}
\title{drawFeatures}
\usage{
drawFeatures(.Object, rbd, col = NULL)

\S4method{drawFeatures}{BTreePlotter}(.Object, rbd, col = "black")
}
\arguments{
\item{.Object}{the object}

\item{rbd}{the rbd object}

\item{col}{the col value}
}
\value{
draw the annotation on the track
}
\description{
draw the features
}
\examples{
load(system.file("data", "allCall.lst.RData", package="BubbleTree"))
load(system.file("data", "cancer.genes.minus2.rda", package="BubbleTree"))
load(system.file("data", "vol.genes.rda", package="BubbleTree"))
load(system.file("data", "gene.uni.clean.gr.rda", package="BubbleTree"))
load(system.file("data", "cyto.gr.rda", package="BubbleTree"))

# 77 common cancer genes merged from 2 sets
comm <- btcompare(vol.genes, cancer.genes.minus2)

btreeplotter <- new("BTreePlotter", branch.col="gray50")
annotator <- new("Annotate")

nn <- "sam12"
cc <- allCall.lst[[nn]]
z <- drawBTree(btreeplotter, cc@rbd.adj) + 
    ggplot2::labs(title=sprintf("\%s (\%s)", nn, info(cc)))
out <- cc@result$dist  \%>\% filter(seg.size >= 0.1 ) \%>\% 
    arrange(gtools::mixedorder(as.character(seqnames)), start)

ann <- with(out, {
    annoByGenesAndCyto(annotator,
                       as.character(out$seqnames),
                       as.numeric(out$start),
                       as.numeric(out$end),
                       comm$comm,
                       gene.uni.clean.gr=gene.uni.clean.gr,
                       cyto.gr=cyto.gr)
})

out$cyto <- ann$cyto
out$genes <- ann$ann
v <- z + drawFeatures(btreeplotter, out)
print(v)
}
