% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTreePlotter.R
\docType{methods}
\name{drawBTree}
\alias{drawBTree}
\alias{drawBTree,BTreePlotter-method}
\alias{drawBTree}
\title{drawBTree}
\usage{
drawBTree(.Object, rbd, size = 1)

\S4method{drawBTree}{BTreePlotter}(.Object, rbd, size = 1)
}
\arguments{
\item{.Object}{the object}

\item{rbd}{the rbd object}

\item{size}{the size}
}
\value{
draw the BTree track
}
\description{
draw the BTree track
}
\examples{

load(system.file("data", "allCall.lst.RData", package="BubbleTree"))
load(system.file("data", "cancer.genes.minus2.rda", package="BubbleTree"))
load(system.file("data", "vol.genes.rda", package="BubbleTree"))
load(system.file("data", "gene.uni.clean.gr.rda", package="BubbleTree"))
load(system.file("data", "cyto.gr.rda", package="BubbleTree"))

# 77 common cancer genes
comm <- btcompare(vol.genes, cancer.genes.minus2)

btreeplotter <- new("BTreePlotter", branch.col="gray50")
annotator <-new("Annotate")
cc <- allCall.lst[["sam2"]]
z <- drawBTree(btreeplotter, cc@rbd.adj) + 
    ggplot2::labs(title=sprintf("\%s (\%s)", "sam2", info(cc)))
}
