% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrackPlotter.R
\docType{methods}
\name{bafTrack}
\alias{bafTrack}
\alias{bafTrack,TrackPlotter-method}
\alias{bafTrack}
\title{bafTrack}
\usage{
bafTrack(.Object, result.dat, gr2, somatic.gr = NULL, min.prev = 0.15,
  cex = 1.2)

\S4method{bafTrack}{TrackPlotter}(.Object, result.dat, gr2, somatic.gr = NULL,
  min.prev = 0.15, cex = 1.2)
}
\arguments{
\item{.Object}{the object}

\item{result.dat}{the result dataframe}

\item{gr2}{the gr2 object}

\item{somatic.gr}{somatic gr object annotation}

\item{min.prev}{previous min}

\item{cex}{the cex}
}
\value{
the highlighted BAF track
}
\description{
get the BAF track
}
\examples{

load(system.file("data", "allCall.lst.RData", package="BubbleTree"))
load(system.file("data", "centromere.dat.rda", package="BubbleTree"))
load(system.file("data", "all.somatic.lst.RData", package="BubbleTree"))
load(system.file("data", "hg19.seqinfo.rda", package="BubbleTree"))

trackplotter <- new("TrackPlotter")
gr2 = centromere.dat
nn <- "sam2"
p2 <- bafTrack(trackplotter,
               result.dat=allCall.lst[[nn]]@result,
               gr2=gr2,
               somatic.gr=all.somatic.lst[[nn]])

}
