% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrackPlotter.R
\docType{methods}
\name{RscoreTrack}
\alias{RscoreTrack}
\alias{RscoreTrack,TrackPlotter-method}
\alias{RscoreTrack}
\title{RscoreTrack}
\usage{
RscoreTrack(.Object, result.dat, gr2, cnv.gr = NULL, min.prev = 0.15,
  ymax = 3, cex = 1.5)

\S4method{RscoreTrack}{TrackPlotter}(.Object, result.dat, gr2, cnv.gr = NULL,
  min.prev = 0.15, ymax = 3, cex = 1.5)
}
\arguments{
\item{.Object}{the object}

\item{result.dat}{the results}

\item{gr2}{the gr2 object}

\item{cnv.gr}{cnv annotation}

\item{min.prev}{previous min}

\item{ymax}{max y}

\item{cex}{the cex}
}
\value{
the highlighted RScore track
}
\description{
get the RScore track
}
\examples{

load(system.file("data", "allCall.lst.RData", package="BubbleTree"))
load(system.file("data", "centromere.dat.rda", package="BubbleTree"))
load(system.file("data", "allCNV.lst.RData", package="BubbleTree"))
load(system.file("data", "hg19.seqinfo.rda", package="BubbleTree"))

gr2 = centromere.dat
trackplotter <- new("TrackPlotter")
nn <- "sam2"
z <- RscoreTrack(trackplotter, allCall.lst[[nn]]@result, gr2, allCNV.lst[[nn]])

}
