% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreastSubtypeR_methods.R
\name{BS_cIHC.itr}
\alias{BS_cIHC.itr}
\title{Iterative Conventional IHC Intrinsic Subtyping (BS_cIHC.itr)}
\usage{
BS_cIHC.itr(
  se_obj,
  iteration = 100,
  ratio = 54/64,
  Subtype = FALSE,
  hasClinical = FALSE,
  seed = 118
)
}
\arguments{
\item{se_obj}{A \code{SummarizedExperiment} object containing:
\itemize{
\item \strong{Assay data}: A log2-transformed, normalized expression matrix with
genes (Gene Symbols) as rows and samples as columns.
\item \strong{Column metadata} (\code{colData}): Must include:
\itemize{
\item \code{"PatientID"}: Unique sample or patient identifier.
\item \code{"ER"}: Estrogen receptor status, coded as \code{"ER+"} or \code{"ER-"}.
}
}}

\item{iteration}{Integer. Number of iterations for the ER-balancing procedure.
Default: 100.}

\item{ratio}{Numeric. Target ER+/ER– ratio for balancing. Options:
\itemize{
\item \code{1:1}: Equal balancing.
\item \code{54:64}: Default; reflects the ER+/ER– ratio in the UNC232 training cohort.
}}

\item{Subtype}{Logical. If \code{TRUE}, returns only the four main subtypes
(Luminal A, Luminal B, HER2-enriched, Basal-like), excluding Normal-like.}

\item{hasClinical}{Logical. If \code{TRUE}, incorporates additional clinical
variables from \code{colData(se_obj)}. Required columns:
\itemize{
\item "TSIZE": Tumor size (0 = \eqn{\le 2}{<= 2} cm; 1 = \eqn{> 2}{> 2} cm).
\item "NODE": Lymph node status (0 = negative; \eqn{\ge 1}{>= 1} = positive). Must be numeric.
}}

\item{seed}{Integer. Random seed for reproducibility.}
}
\value{
A list containing:
\itemize{
\item \code{subtypes}: Intrinsic subtype predictions across iterations.
\item \code{confidence}: Confidence estimates for each assigned subtype.
\item \code{ER_balance}: Proportions of ER+ and ER– subsets observed across iterations.
}
}
\description{
Implements an \strong{iterative} version of the conventional IHC-based intrinsic
subtyping approach. This method repeatedly balances samples by estrogen
receptor (ER) status across multiple iterations, allowing refinement of
subtype calls in ER-skewed cohorts. Users can customise the ER+/ER– ratio to
match specific cohort assumptions (e.g., training distribution).
}
\examples{
data("OSLO2EMIT0obj")
res <- BS_cIHC.itr(
    se_obj = OSLO2EMIT0obj$data_input$se_NC,
    iteration = 10, ## for final analysis, use iteration = 100
    Subtype = FALSE,
    hasClinical = FALSE
)

}
\references{
Curtis C, Shah SP, Chin SF, Turashvili G, Rueda OM, Dunning MJ, et al.
\emph{The genomic and transcriptomic architecture of 2,000 breast tumors reveals novel subgroups.}
Nature. 2012;486(7403):346–352.
https://doi.org/10.1038/nature10983
}
