% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreastSubtypeR_methods.R
\name{BS_AIMS}
\alias{BS_AIMS}
\title{AIMS Intrinsic Subtyping (BS_AIMS)}
\usage{
BS_AIMS(se_obj)
}
\arguments{
\item{se_obj}{A \code{SummarizedExperiment} object containing:
\itemize{
\item \strong{Assay data}: A gene expression matrix with genes (Entrez IDs) as rows
and samples as columns.
\itemize{
\item Expression values must be \strong{positive} (e.g., FPKM or log2(FPKM+1)).
\item Values should not be gene-centered or globally scaled.
}
}}
}
\value{
A \strong{list} with the following elements:
\itemize{
\item \code{cl}: Character vector of AIMS subtype calls per sample.
One of \code{"Basal"}, \code{"Her2"}, \code{"LumA"}, \code{"LumB"}, or \code{"Normal"}.
\item \code{prob}: Numeric vector of posterior probabilities corresponding
to the assigned subtype in \code{cl} (one value per sample).
\item \code{all.probs}: Matrix of posterior probabilities for all samples
and all subtypes (rows = samples, columns = subtypes).
\item \code{rules.matrix}: 0/1 matrix of the 100 AIMS rules used for assignment
(rows = rules, columns = samples); \code{1} indicates the rule evaluated to TRUE.
\item \code{data.used}: Expression values actually used to evaluate the rules
(filtered/ordered subset aligned to the AIMS gene set).
\item \code{EntrezID.used}: Character vector of Entrez IDs used by AIMS.
}
}
\description{
Implements the \strong{AIMS (Absolute Assignment of Intrinsic Molecular Subtype)}
method for breast cancer intrinsic subtyping. Unlike nearest-centroid (NC)
approaches, AIMS is a single-sample predictor (SSP): it assigns subtypes
independently for each sample using within-sample, pairwise gene expression
rules. This makes it robust to cohort composition and scaling.
}
\examples{
## Example using SummarizedExperiment input
data("OSLO2EMIT0obj")
res <- BS_AIMS(
    se_obj = OSLO2EMIT0obj$data_input$se_SSP
)

}
\references{
Paquet ER, Hallett MT.
\emph{Absolute assignment of breast cancer intrinsic molecular subtype.}
Journal of the National Cancer Institute. 2015;107(1):dju357.
https://doi.org/10.1093/jnci/dju357
}
