% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skPartial.R
\name{skIncrPPCA}
\alias{skIncrPPCA}
\alias{skIncrPPCA,SummarizedExperiment-method}
\title{optionally fault tolerant incremental partial PCA for projection of samples from SummarizedExperiment}
\usage{
skIncrPPCA(
  se,
  chunksize,
  n_components,
  assayind = 1,
  picklePath = "./skIdump.pkl",
  matTx = force,
  ...
)
}
\arguments{
\item{se}{instance of SummarizedExperiment}

\item{chunksize}{integer number of samples per step}

\item{n_components}{integer number of PCs to compute}

\item{assayind}{not used, assumed set to 1}

\item{picklePath}{if non-null, incremental results saved here via joblib.dump, for each chunk.  If NULL, no saving of incremental results.}

\item{matTx}{a function defaulting to force() that accepts a matrix and returns a matrix with identical dimensions, e.g., \code{function(x) log(x+1)}}

\item{\dots}{not used}
}
\value{
python instance of \code{sklearn.decomposition.incremental_pca.IncrementalPCA}
}
\description{
optionally fault tolerant incremental partial PCA for projection of samples from SummarizedExperiment
}
\note{
Will treat samples as records and all features (rows)
as attributes, projecting.
to an \code{n_components}-dimensional space.  Method will
acquire chunk of assay data
and transpose before computing PCA contributions.
In case of crash, restore from \code{picklePath} using
\code{joblib$load} after loading reticulate.  You can
use the \code{n_samples_seen_} component of the restored
python reference to determine where to restart.
You can manage resumption using \code{skPartialPCA_step}.
}
\examples{
# demo SE made with TENxGenomics:
# mm = matrixSummarizedExperiment(h5path, 1:27998, 1:750)
# saveHDF5SummarizedExperiment(mm, "tenx_750")
#
if (FALSE) {
if (requireNamespace("HDF5Array")) {
  se750 = HDF5Array::loadHDF5SummarizedExperiment(
     system.file("hdf5/tenx_750", package="BiocSklearn"))
  lit = skIncrPPCA(se750[, 1:50], chunksize=5, n_components=4)
  round(cor(pypc <- lit$transform(dat <- t(as.matrix(assay(se750[,1:50]))))),3)
  rpc = prcomp(dat)
  round(cor(rpc$x[,1:4], pypc), 3)
} # this has to be made basilisk-compliant
} # and is blocked until then
}
