% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5mat.R
\name{h5mat}
\alias{h5mat}
\title{create a file connection to HDF5 matrix}
\usage{
h5mat(infile, mode = "r", ...)
}
\arguments{
\item{infile}{a pathname to an HDF5 file}

\item{mode}{character(1) defaults to "r", see py_help for h5py.File}

\item{\dots}{unused}
}
\value{
instance of (S3) h5py._hl.files.File
}
\description{
create a file connection to HDF5 matrix
}
\note{
The result of this function must be used with basiliskRun with the
env argument set to bsklenv, or there is a risk of
inconsistent python modules being invoked.  This should only be used
with the persistent environment discipline of basilisk.
}
\examples{
if (interactive()) {   # not clear why
fn = system.file("ban_6_17/assays.h5", package="BiocSklearn")
proc = basilisk::basiliskStart(BiocSklearn:::bsklenv)
basilisk::basiliskRun(proc, function(infile, mode="r") {
 h5py = reticulate::import("h5py") 
 hh = h5py$File( infile, mode=mode )
 cat("File reference:\n ")
 print(hh)
 cat("File attributes in python:\n ")
 print(head(names(hh)))
 cat("File keys in python:\n ")
 print(hh$keys())
 cat("HDF5 dataset in python:\n ")
 print(hh['assay001'])
}, infile=fn, mode="r")
basilisk::basiliskStop(proc)
}
}
