% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url_ref.R
\name{url_ref}
\alias{url_ref}
\alias{url_ref_element}
\alias{url_ref_set}
\title{Functions to access reference urls for different identifiers}
\usage{
url_ref_element(es)

url_ref_set(es)

url_ref(es)
}
\arguments{
\item{es}{A \code{BiocSet} object that the reference urls should be added to.}
}
\value{
For \code{url_ref_element}, a \code{BiocSet} object with the url 
    column added to the element tibble.

For \code{url_ref_set}, a \code{BiocSet} object with the url column 
    added to the set tibble.

For \code{url_ref}, a \code{BiocSet} object with the url column 
    added to both the element and set tibbles.
}
\description{
Functions to access reference urls for different identifiers
}
\examples{
es <- BiocSet("GO:0000002" = c("TP53", "TNF"), "GO:0000003" = c("IL6"))
url_ref_element(es) 

url_ref_set(es)

url_ref(es)
}
