% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_funs.R
\name{set_funs}
\alias{set_funs}
\alias{filter_set}
\alias{select_set}
\alias{mutate_set}
\alias{summarise_set}
\alias{arrange_set}
\alias{left_join_set}
\alias{tibble_from_set}
\alias{data.frame_from_set}
\title{Functions applied to sets in a \code{BiocSet} object}
\usage{
filter_set(.data, ...)

select_set(.data, ...)

mutate_set(.data, ...)

summarise_set(.data, ...)

arrange_set(.data, ...)

left_join_set(.data, ...)

tibble_from_set(.data, how = unlist)

data.frame_from_set(.data, how = unlist)
}
\arguments{
\item{.data}{A \code{BiocSet} object.}

\item{...}{Additional argument passed to the function.}

\item{how}{Multiple entries will become a list.}
}
\value{
A \code{BiocSet} object.

For \code{tibble_from_set}, a tibble.

For \code{data.frame_from_set}, a data.frame.
}
\description{
All of the major methods applied to a \code{BiocSet} object can
    be explicitly applied to the set tibble. These functions bypass the need
    to use the \code{es_activate} function by indicating what function should
    be used on the element tibble.
}
\examples{
es <- BiocSet(set1 = letters, set2 = LETTERS)
filter_set(es, set == "set1")

es \%>\% select_set(set)

es \%>\% mutate_set(pval = rnorm(1:2))

es \%>\% summarise_set(n = n())

es \%>\% arrange_set(desc(set))

tbl <- tibble(x = 10:11, y = c("set1", "set2"))
es <- BiocSet(set1 = letters[c(1,3,5)], set2 = letters[c(2,4)])
left_join_set(es, tbl, by = c(set = "y"))

tibble_from_set(es)

data.frame_from_set(es)
}
