% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-GMT.R, R/import-OBO.R
\name{import}
\alias{import}
\alias{import,GMTFile,ANY,ANY-method}
\alias{export,BiocSet,GMTFile,ANY-method}
\alias{import,OBOFile,ANY,ANY-method}
\alias{export,BiocSet,OBOFile,ANY-method}
\title{Importing/exporting}
\usage{
\S4method{import}{GMTFile,ANY,ANY}(con, format, text, ...)

\S4method{export}{BiocSet,GMTFile,ANY}(object, con, format, ...)

\S4method{import}{OBOFile,ANY,ANY}(con, format, text, ...)

\S4method{export}{BiocSet,OBOFile,ANY}(object, con, format, ...)
}
\arguments{
\item{con}{For \code{import}, the file name or URL the element set is
loaded from. For \code{export}, the file name or URL the element set is
written to.}

\item{format}{For \code{import}, the format of the input. For 
\code{export}, the format of the output.}

\item{text}{If con is missing this is a character vector directly providing 
the element set that should be imported.}

\item{...}{Parameters to pass to the format-specific method}

\item{object}{For `export()`, the object to be exported.}
}
\value{
For `import()`, a BiocSet object

For `export()`, a GMTFile object representing the location
    where the BiocSet object was written to
}
\description{
Importing/exporting and formating of element sets as a 
    \code{BiocSet} object.
}
\examples{
gmtFile <- system.file(package = "BiocSet", "extdata",
    "hallmark.gene.symbol.gmt")
tbl <- import(gmtFile)

tbl2 <- BiocSet(set1 = letters, set2 = LETTERS)
fl <- tempfile(fileext = ".gmt")
gmt <- export(tbl2, fl)

oboFile <- system.file(package = "BiocSet", "extdata", "sample_go.obo")
tst_obo <- import(oboFile)
fl <- system.file("extdata", "sample_go.obo", package = "BiocSet")
tbl <- import(fl)
new_fl <- tempfile(fileext = ".obo")
obo <- export(tbl, new_fl)
}
