% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocSet-class.R
\docType{methods}
\name{BiocSet}
\alias{BiocSet}
\alias{BiocSet-class}
\alias{show,BiocSet-method}
\alias{es_element}
\alias{es_element,BiocSet-method}
\alias{es_set}
\alias{es_set,BiocSet-method}
\alias{es_elementset}
\alias{es_elementset,BiocSet-method}
\alias{BiocSet_from_elementset}
\title{BiocSet class}
\usage{
BiocSet(..., metadata = list(), active = c("elementset", "element", "set"))

\S4method{show}{BiocSet}(object)

es_element(x)

\S4method{es_element}{BiocSet}(x)

es_set(x)

\S4method{es_set}{BiocSet}(x)

es_elementset(x)

\S4method{es_elementset}{BiocSet}(x)

BiocSet_from_elementset(elementset, element, set, metadata)
}
\arguments{
\item{...}{Named character() vectors of element sets, or a named
list of character() vectors. Each character vector is an
element set. The names of the character vectors are the names of
the sets.}

\item{metadata}{A list() with arbitrary content, describing the set.}

\item{active}{A character(1) to indicate which tibble is active. The
default is "elementset".}

\item{object}{A \code{BiocSet} object.}

\item{x}{A \code{BiocSet} object.}

\item{elementset}{A tibble with element set information.}

\item{element}{A tibble with element information.}

\item{set}{A tibble with set information.}
}
\value{
An S4 \code{BiocSet} object shown as a tripple tibble,
    where each slot is a tibble.
}
\description{
character()

The \code{BiocSet} constructor, the show method, the
    slot accessors, and creating a \code{BiocSet} object from an
    element set tibble rather than character vector(s).
}
\section{Slots}{

\describe{
\item{\code{element}}{The element tibble from `tbl_elementset`}

\item{\code{set}}{The set tibble from `tbl_elementset`}

\item{\code{elementset}}{The elementset tibble created from user input}

\item{\code{active}}{A character(1), indicates which tibble is active}

\item{\code{metadata}}{A list() with arbitrary elements describing the set}
}}

\examples{
BiocSet(set1 = letters, set2 = LETTERS)
lst <- list(set1 = letters, set2 = LETTERS)
BiocSet(lst)

set.seed(123)
element <-
   tibble(
       element = letters[1:10],
       v1 = sample(10),
       v2 = sample(10)
   )
set <-
   tibble(
       set = LETTERS[1:2],
       v1 = sample(2),
       v2 = sample(2)
   )
elementset <-
   tibble(
       element = letters[1:10],
       set = sample(LETTERS[1:2], 10, TRUE)
   )
BiocSet_from_elementset(elementset, element, set)
}
