% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPkgDependencyGraph.R
\name{buildPkgDependencyIgraph}
\alias{buildPkgDependencyIgraph}
\title{Work with package dependencies as a graph}
\usage{
buildPkgDependencyIgraph(pkgDepDF)
}
\arguments{
\item{pkgDepDF}{a tidy data frame. See description for
details.}
}
\value{
An igraph directed graph. See the igraph
package for details of what can be done.
}
\description{
Package dependencies represent a directed
graph (though Bioconductor dependencies are
not an acyclic graph). This function simply
returns an igraph graph from the package
dependency data frame from a call to
\code{\link[=buildPkgDependencyDataFrame]{buildPkgDependencyDataFrame()}} or
any tidy data frame with rows of (Package, dependency)
pairs. Additional columns are added as igraph edge
attributes (see \code{\link[igraph:graph_from_data_frame]{igraph::graph_from_data_frame()}}).
}
\examples{

library(igraph)

pkg_dep_df = buildPkgDependencyDataFrame()

# at this point, filter or join to manipulate
# dependency data frame as you see fit.

g = buildPkgDependencyIgraph(pkg_dep_df)
g

# Look at nodes and edges
head(V(g)) # vertices
head(E(g)) # edges

# subset graph by attributes


head(sort(degree(g, mode='in'), decreasing=TRUE))
head(sort(degree(g, mode='out'), decreasing=TRUE))

}
\seealso{
See \code{\link[=buildPkgDependencyDataFrame]{buildPkgDependencyDataFrame()}},
\code{\link[igraph:graph_from_data_frame]{igraph::graph_from_data_frame()}},
\code{\link[=inducedSubgraphByPkgs]{inducedSubgraphByPkgs()}}, \code{\link[=subgraphByDegree]{subgraphByDegree()}},
\link[igraph:igraph-es-indexing]{igraph::igraph-es-indexing},
\link[igraph:igraph-vs-indexing]{igraph::igraph-vs-indexing}
}
