% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocMaintained.R
\name{biocMaintained}
\alias{biocMaintained}
\alias{hasBiocMaint}
\title{Bioconductor Maintained Packages}
\usage{
biocMaintained(
  main = "maintainer@bioconductor.org",
  version = BiocManager::version(),
  pkgType = c("software", "data-experiment", "workflows", "data-annotation")
)

hasBiocMaint(
  pkg,
  version = BiocManager::version(),
  main = "maintainer@bioconductor\\\\.org",
  repo = c("BioCsoft", "BioCexp", "BioCworkflows", "BioCann")
)
}
\arguments{
\item{main}{\code{character(1)} A regex string to search for in the \code{Maintainer}
column from the \code{biocPkgList()} output.}

\item{version}{\code{character(1)} or \code{package_version} indicating the
\emph{Bioconductor} version (e.g., "3.22"). Defaults to the "current version"
provided by \code{BiocManager::version()}. The keywords "release" and "devel"
are also accepted.}

\item{pkgType}{\code{character()} The type of packages for which to get
information for. Values can be one or more of the following:
\itemize{
\item \code{software}: Software packages
\item \code{data-experiment}: Experiment data packages
\item \code{data-annotation}: Annotation data packages
\item \code{workflows}: Workflow packages
}}

\item{pkg}{\code{character(1)} A vector of package names (case sensitive).}

\item{repo}{\code{character()} A vector of Bioconductor repositories to search
through. By default, it will search through all Bioconductor repositories.}
}
\value{
For \code{biocMaintained}: a \code{tibble} of packages associated with the
maintainer.

For \code{hasBiocMaint}: a logical vector indicating whether the
package is maintained by Bioconductor.
}
\description{
List all the packages associated with a maintainer. By default, it will
return all packages associated with the \code{maintainer@bioconductor.org} email.
\code{hasBiocMaint} returns a logical vector corresponding to the input character
vector of packages indicating whether any package is maintained by the
Bioconductor core team.
}
\examples{

biocMaintained()

## maintained by Hervé and not maintainer at bioconductor dot org
hasBiocMaint("BiocGenerics")

}
