% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocPkgTools.R
\docType{package}
\name{BiocPkgTools}
\alias{BiocPkgTools-package}
\alias{BiocPkgTools}
\title{BiocPkgTools: Examine and analyze Bioconductor package metadata}
\description{
Bioconductor has a rich ecosystem of metadata around
packages, usage, and build status. This package is a simple
collection of functions to access that metadata from R. The goal
is to expose metadata for data mining and value-added functionality
such as package searching, text mining, and analytics on
packages.
}
\section{For developers}{

The \code{\link[=biocBuildReport]{biocBuildReport()}} function returns a computable
form of the Bioconductor Build Report.
}

\section{For users}{

The \code{\link[=biocDownloadStats]{biocDownloadStats()}} function gets Bioconductor
download stats, allowing users to quickly find commonly used
packages. The \code{\link[=biocPkgList]{biocPkgList()}} is useful for getting
a complete listing of all Bioconductor packages.
}

\section{Infrastructure}{

Bioconductor packages all have Digital Object Identifiers (DOIs).
This package contains basic infrastructure for creating, updating,
and de-referencing DOIs.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/seandavi/BiocPkgTools}
  \item Report bugs at \url{https://github.com/seandavi/BiocPkgTools/issues/new}
}

}
\author{
\strong{Maintainer}: Sean Davis \email{seandavi@gmail.com}

Authors:
\itemize{
  \item Shian Su \email{su.s@wehi.edu.au} [contributor]
  \item Marcel Ramos \email{marcel.ramos@sph.cuny.edu} (\href{https://orcid.org/0000-0002-3242-0582}{ORCID}) [contributor]
}

Other contributors:
\itemize{
  \item Lori Shepherd \email{Lori.Shepherd@roswellpark.org} [contributor]
  \item Felix G.M. Ernst \email{felix.gm.ernst@outlook.com} [contributor]
  \item Jennifer Wokaty \email{jennifer.wokaty@gmail.com} [contributor]
  \item Charlotte Soneson \email{charlottesoneson@gmail.com} [contributor]
  \item Martin Morgan \email{martin.morgan@roswellpark.org} [contributor]
  \item Vince Carey \email{stvjc@channing.harvard.edu} [contributor]
}

}
