% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{simulation_Ic}
\alias{simulation_Ic}
\title{Calculating random Index of Critical transition (Ic scores) for randomly-selectd genes}
\usage{
simulation_Ic(
  obs.x,
  sampleL,
  counts,
  B = 1000,
  fun = c("cor", "BioTIP"),
  shrink = TRUE,
  use = c("everything", "all.obs", "complete.obs", "na.or.complete",
    "pairwise.complete.obs"),
  output = c("Ic", "PCCg", "PCCs")
)
}
\arguments{
\item{obs.x}{An integer, length of identified CTS.}

\item{sampleL}{A list of vectors,  whose length is the number of states.
Each vector gives the sample names in a state. Note that the vector s (sample names)
has to be among the column names of the R object 'df'.}

\item{counts}{A numeric matrix or dataframe in which columns are samples and rows are transcripts.
Each row needs to have a unique row name (i.e. transcript ID).}

\item{B}{An integer, setting the permutation with \code{B} runs. Default is 1000.}

\item{fun}{An optional character string indicating the R functon to calculate correlations
for all possible pairs of columns of a matrix.
When using "BioTIP",  The method is modified to ignore missing values, analogous to how
\code{cor(X,  use = "pairwise.complete.obs")} works.
Note that the "BioTIP" option only function together with shrink = TRUE.}

\item{shrink}{A flag specifying whether to shrink the correlation or not.
This appraoch uses the method outlined by Schafer and Strimmer in
"A Shrinkage Approach to Large-Scale Covariance Matrix Estimation
and Implications for Functional Genomics" (2005)
Comparing to fun='cor', the 'BioTIP' method without shinkage is modified
to ignore missing values, analogous to how \code{cor(X, use = "pairwise.complete.obs")} works.}

\item{use}{An optional character string,  when fun=="cor", it gives a method
for computing covariances in the presence of missing values.
This must be (an abbreviation of) one of the strings "everything",  "all.obs",
"complete.obs",  "na.or.complete",  or "pairwise.complete.obs".}

\item{output}{A string. Please select from 'Ic',  'PCCg',  or 'PCCs'. Uses 'Ic' by default.
'PCCg' is the PCC between genes (numerator) and 'PCCs' is PCC between samples (denominator)}
}
\value{
A matrix of \code{y} rows and \code{B} columns where \code{y}
is the length of \code{sampleL} and \code{B} is self-defined. Each column is a set of Ic scores calculated for each state
}
\description{
Simulating Ic scores for \code{x} randomly selected samples, where x should be the same
as the length of identified critical-transition signal (CTS) (e.g.,  number of genes) and \code{B} is self-defined running times.
}
\examples{
counts = matrix(sample(1:100, 27), 3, 9)
colnames(counts) = 1:9
row.names(counts) = c('loci1', 'loci2', 'loci3')
cli = cbind(1:9, rep(c('state1', 'state2', 'state3'), each = 3))
colnames(cli) = c('samples', 'group')
samplesL <- split(cli[, 1], f = cli[, 'group'])
simulation_Ic(2, samplesL, counts, B =3, fun="BioTIP", shrink=TRUE)
}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}
}
