% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{plotMaxMCI}
\alias{plotMaxMCI}
\title{Plot the Maximized MCI per State}
\usage{
plotMaxMCI(maxMCIms, MCIl, las = 0, order = NULL, states = NULL)
}
\arguments{
\item{maxMCIms}{A list of 2 elements. The 1st element is an integer vector of module ids whose names are the state names.
The 2nd element is a list of character vectors per state. The vectors are network nodes (e.g. transcript ids).
This parameter can be obtained by running function \code{\link{getMaxMCImember}}.}

\item{MCIl}{A list of numeric vectors whose names are unique cluster ids.
Each vector represents the MCI scores of modules in a state.
This can be the second element of the output from the function \code{\link{getMCI}}.}

\item{las}{Numeric in {0, 1, 2, 3}; the style of axis labels. Default is 0, meaning labels are parallel.
See \code{\link{getMCI}} for more detail.}

\item{order}{A vector of state names in the customized order to be plotted, setting to NULL by default.}

\item{states}{A character vector of state names that will be shown on the plot, setting to NULL by default.
Assign this if you want to show all states, including states with no resulted modules.
This parameter will overwrite the parameter 'order'.}
}
\value{
Returns a line plot of maximum MCI scores across the states
}
\description{
This function generates a line plot over multiple states with the maximum MCI score per state.
The module size (i.e., number of network nodes) is specified at each state in parentheses.
}
\examples{
maxMCIms = list(c(state1 = 1,  state2 = 2,  state3 = 1), 
   c(list(state1 = c('g1', 'g2', 'g3'), 
   state2 = c('g3', 'g5'), 
   state3 = c('g2', 'g6'))))
   
MCIl = list(state1=c('1' = 8.84, '2' = 6.4),  
   state2 = c('1' =NA, '2' = 9.5, '3' = NA),    
   state3 = c('1' = 2.3, '2' = 1.4))
   
plotMaxMCI(maxMCIms, MCIl)

}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}
}
