% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{plotBar_MCI}
\alias{plotBar_MCI}
\title{plot MCI barplots}
\usage{
plotBar_MCI(
  MCIl,
  ylim = NULL,
  nr = 1,
  nc = NULL,
  order = NULL,
  minsize = 3,
  states = NULL
)
}
\arguments{
\item{MCIl}{A list can be obtained through getMCI.}

\item{ylim}{A vector needed if the output barplots need to be on the same y scale.}

\item{nr}{The number of rows to plot.}

\item{nc}{The number of columns to plot,  default length(groups).}

\item{order}{A character vector of the order of the barplot.
Default is NULL which uses the input list order.}

\item{minsize}{A non-negative numeric value of minimum size allowed for a cluster.}

\item{states}{A character of the state names to be shown on the plot. Default is NULL,
assign this if you want to show all states including states without nodes.}
}
\value{
Return a barplot of MCI scores across states.
}
\description{
A barplot of MCI for all clusters in all states.
}
\examples{
test = list('state1' = matrix(sample(1:10, 6), 4, 3), 
  'state2' = matrix(sample(1:10, 6), 4, 3), 
  'state3' = matrix(sample(1:10, 6), 4, 3))
# assign colnames and rownames to the matrix
for(i in names(test)){
 colnames(test[[i]]) = 1:3
 row.names(test[[i]]) = c('g1', 'g2', 'g3', 'g4')
}

cluster = list(c(1, 2, 2, 1),  c(1, 2, 3, 1),  c(2, 2, 1, 1))
names(cluster) = names(test)
for(i in names(cluster)){
 names(cluster[[i]]) = c('g1', 'g2', 'g3', 'g4')
}
membersL_noweight <- getMCI(cluster, test)
plotBar_MCI(membersL_noweight)

}
\references{
Chen L, Liu R, Liu Z, Li M & Aihara K (2012)
Detecting early-warning signals for sudden deterioration of complex diseases by dynamical network biomarkers
Scientific Reports 2:342
}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}
}
