% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{getIc}
\alias{getIc}
\title{Get Index for Critical transition (Ic score)}
\usage{
getIc(
  counts,
  sampleL,
  genes,
  output = c("Ic", "PCCg", "PCCs"),
  fun = c("cor", "BioTIP"),
  shrink = TRUE,
  use = c("everything", "all.obs", "complete.obs", "na.or.complete",
    "pairwise.complete.obs")
)
}
\arguments{
\item{counts}{A  numeric matrix or data frame. The rows and columns represent unique transcript IDs (geneID)
and sample names,  respectively.}

\item{sampleL}{A list of vectors, whose length is the number of states. Each vector gives the sample names in a state.
Note that the vector s (sample names) has to be among the column names of the R object 'df'.}

\item{genes}{A character vector consisting of unique CTS gene ids. This can be obtained from \code{\link{getMaxMCImember}}}

\item{output}{A string. Please select from 'Ic',  'PCCg',  or 'PCCs'. Uses 'Ic' by default.
'PCCg' is the PCC between genes (numerator) and 'PCCs' is PCC between samples (denominator)}

\item{fun}{An optional character string indicating the R functon to calculate correlations
for all possible pairs of columns of a matrix.
When using "BioTIP",  The method is modified to ignore missing values, analogous to how
\code{cor(X,  use = "pairwise.complete.obs")} works.
Note that the "BioTIP" option only function together with shrink = TRUE.}

\item{shrink}{A flag specifying whether to shrink the correlation or not.
This appraoch uses the method outlined by Schafer and Strimmer in
"A Shrinkage Approach to Large-Scale Covariance Matrix Estimation
and Implications for Functional Genomics" (2005)
Comparing to fun='cor', the 'BioTIP' method without shinkage is modified
to ignore missing values, analogous to how \code{cor(X, use = "pairwise.complete.obs")} works.}

\item{use}{An optional character string,  when fun=="cor",  it gives a method
for computing covariances in the presence of missing values.
This must be (an abbreviation of) one of the strings "everything", "all.obs",
"complete.obs", "na.or.complete", or "pairwise.complete.obs".}
}
\value{
A list of numeric values,  whose length and names are inherited from \code{sampleL}
}
\description{
Retrieve Ic scores (Pearson correlation of genes / Pearson correlation of samples)
for the identified critical transition state
}
\examples{
counts = matrix(sample(1:100, 27),  3,  9)
colnames(counts) = 1:9
row.names(counts) = c('loci1', 'loci2', 'loci3')
cli = cbind(1:9, rep(c('state1', 'state2', 'state3'), each = 3))
colnames(cli) = c('samples', 'group')
samplesL <- split(cli[, 1],  f = cli[, 'group'])
CTS = c('loci1', 'loci2')

## Comparing the results with an estiamted correlation matrix with that without estimation.
Ic = getIc(counts,  samplesL,  CTS, fun='cor')
Ic.2 = getIc(counts,  samplesL,  CTS, fun='BioTIP', shrink=FALSE)
BioTIP = getIc(counts,  samplesL,  CTS, fun='BioTIP')

}
\references{
Schafer and Strimmer (2005) "A Shrinkage Approach to Large-Scale
Covariance Matrix Estimation and Implications for Functional Genomics"

M. Mojtahedi et al., Cell Fate Decision as High-Dimensional Critical State Transition.
PLoS Biol 14,  e2000640 (2016).
}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}; Xinan H Yang \email{xyang2@uchicago.edu}
}
