% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini.R
\name{gini}
\alias{gini}
\title{Calculate Gini Index of a numeric vector}
\usage{
gini(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A numeric value between 0 and 1.
}
\description{
Calculate the Gini index of a numeric vector.
}
\details{
The Gini index (Gini coefficient) is a measure of statistical dispersion. A Gini
coefficient of zero expresses perfect equality where all values are
the same. A Gini coefficient of one expresses maximal inequality among values.
}
\examples{
testValues <- runif(100)
gini(testValues)
}
\references{
Gini. C. (1912) \emph{Variability and Mutability}, C. Cuppini, Bologna
156 pages.
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
