% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{entropySpecificity}
\alias{entropySpecificity}
\title{Entropy-based gene-expression specificity}
\usage{
entropySpecificity(mat, norm = FALSE)
}
\arguments{
\item{mat}{A matrix (usually an expression matrix), with genes (features) in rows and samples in columns.}

\item{norm}{Logical, whether the specificity should be normalized by \code{log2(ncol(mat))}.}
}
\value{
A vector of the length of the row number of the input matrix, namely the specificity score of genes.
}
\description{
Entropy-based gene-expression specificity
}
\examples{
myMat <- rbind(c(3,4,5),c(6,6,6), c(0,2,4))
entropySpecificity(myMat)
entropySpecificity(myMat, norm=TRUE)

myRandomMat <- matrix(runif(1000), ncol=20)
entropySpecificity(myRandomMat)
entropySpecificity(myRandomMat, norm=TRUE)
}
\references{
Martinez and Reyes-Valdes (2008) Defining diversity, 
specialization, and gene specificity in transcriptomes through information 
theory. PNAS 105(28):9709--9714
}
\seealso{
\code{\link{entropy}}
}
