% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory_analysis.R
\name{plot_PCA}
\alias{plot_PCA}
\title{Plot Principal Component Analysis (PCA) of samples}
\usage{
plot_PCA(
  exp,
  metadata,
  metadata_cols = NULL,
  log_trans = FALSE,
  PCs = c(1, 2),
  size = 2
)
}
\arguments{
\item{exp}{A gene expression data frame with genes in row names
and samples in column names or a `SummarizedExperiment` object.}

\item{metadata}{A data frame of sample metadata containing sample names
in row names and sample annotation in subsequent columns.
Ignored if `exp` is a `SummarizedExperiment` object, since colData will be
automatically extracted.}

\item{metadata_cols}{A vector (either numeric or character) indicating
which columns should be extracted from column metadata if \strong{exp}
is a `SummarizedExperiment` object. The vector can contain column
indices (numeric) or column names (character). By default, all columns are
used.}

\item{log_trans}{Logical indicating whether the gene expression matrix
should be log transformed using \code{log(exp + 1)}. Default: FALSE.}

\item{PCs}{Numeric vector of length 2 indicating the principal components
to be plotted on the x-axis and y-axis, respectively.
Default: \code{c(1, 2)}.}

\item{size}{Numeric indicating the point size. Default is 2.}
}
\value{
A ggplot object with the PCA plot.
}
\description{
Plot Principal Component Analysis (PCA) of samples
}
\examples{
data(zma.se)
plot_PCA(zma.se, log_trans = TRUE)
}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
\author{
Fabricio Almeida-Silva
}
