% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grn_inference.R
\name{grn_combined}
\alias{grn_combined}
\title{Infer gene regulatory network with multiple algorithms and combine results in a list}
\usage{
grn_combined(
  exp,
  regulators = NULL,
  eps = 0.1,
  estimator_aracne = "spearman",
  estimator_clr = "pearson",
  remove_zero = TRUE,
  ...
)
}
\arguments{
\item{exp}{A gene expression data frame with genes in row names and
samples in column names or a `SummarizedExperiment` object.}

\item{regulators}{A character vector of regulators
(e.g., transcription factors or miRNAs). All regulators must be
included in `exp`.}

\item{eps}{Numeric value indicating the threshold used when removing
an edge: for each triplet of nodes (i,j,k), the weakest edge, say (ij),
is removed if its weight is below \code{min\{(ik),(jk)\}} - eps. Default: 0.1.}

\item{estimator_aracne}{Entropy estimator to be used in ARACNE inference.
One of "mi.empirical", "mi.mm", "mi.shrink", "mi.sg", "pearson", "spearman",
or "kendall". Default: "spearman".}

\item{estimator_clr}{Entropy estimator to be used in CLR inference.
One of "mi.empirical", "mi.mm", "mi.shrink", "mi.sg", "pearson", "spearman",
or "kendall". Default: "pearson".}

\item{remove_zero}{Logical indicating whether to remove edges
whose weight is exactly zero. Zero values indicate edges that were
removed by ARACNE. Default: TRUE.}

\item{...}{Additional arguments passed to `GENIE3::GENIE3()`.}
}
\value{
A list of data frames representing edge lists. Each list element
is an edge list for a specific method.
}
\description{
Infer gene regulatory network with multiple algorithms and combine results in a list
}
\examples{
data(filt.se)
tfs <- sample(rownames(filt.se), size=50, replace=FALSE)
grn_list <- grn_combined(filt.se, regulators=tfs, nTrees=2)
}
