% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_modules.R
\name{consensus_SFT_fit}
\alias{consensus_SFT_fit}
\title{Pick power to fit networks to scale-free topology}
\usage{
consensus_SFT_fit(
  exp_list,
  setLabels = NULL,
  metadata = NULL,
  cor_method = "spearman",
  net_type = "signed hybrid",
  rsquared = 0.8
)
}
\arguments{
\item{exp_list}{A list of expression data frames or
SummarizedExperiment objects.
If input is a list of data frames, row names must correspond to gene IDs
and column names to samples.
The list can be created with \code{list(exp1, exp2, ..., expn)}.}

\item{setLabels}{Character vector containing labels for each expression set.}

\item{metadata}{A data frame containing sample names in row names and
sample annotation in the first column.
Ignored if `exp_list` is a list of `SummarizedExperiment` objects, since
the function will extract colData.}

\item{cor_method}{Correlation method used for network reconstruction.
One of "spearman" (default), "biweight", or "pearson".}

\item{net_type}{Network type. One of "signed hybrid" (default),
"signed" or "unsigned".}

\item{rsquared}{Minimum R squared to consider the network similar to
a scale-free topology. Default is 0.8.}
}
\value{
A list of 2 elements: \describe{
  \item{power}{Numeric vector of optimal beta powers to fit networks to SFT}
  \item{plot}{A ggplot object displaying main statistics of the SFT fit test}
}
}
\description{
Pick power to fit networks to scale-free topology
}
\examples{
set.seed(12)
data(zma.se)
filt.zma <- filter_by_variance(zma.se, n=500)
zma.set1 <- filt.zma[, sample(colnames(filt.zma), size=20, replace=FALSE)]
zma.set2 <- filt.zma[, sample(colnames(filt.zma), size=20, replace=FALSE)]
list.sets <- list(zma.set1, zma.set2)
cons_sft <- consensus_SFT_fit(list.sets, setLabels = c("Maize1", "Maize2"),
                              cor_method = "pearson")
}
