% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_SFT}
\alias{check_SFT}
\title{Check scale-free topology fit for a given network}
\usage{
check_SFT(edgelist, net_type = "gcn")
}
\arguments{
\item{edgelist}{Edge list as a data frame containing node 1,
node 2 and edge weight.}

\item{net_type}{Type of biological network. One of "gcn", "grn", or "ppi".
Default: gcn.}
}
\value{
A list with SFT fit statistics and a message indicating if
the network is scale-free.
}
\description{
Check scale-free topology fit for a given network
}
\examples{
set.seed(1)
exp <- t(matrix(rnorm(10000), ncol=1000, nrow=200))
rownames(exp) <- paste0("Gene", 1:nrow(exp))
colnames(exp) <- paste0("Sample", 1:ncol(exp))
cormat <- cor(t(exp))
edges <- cormat_to_edgelist(cormat)
edges <- edges[abs(edges$Weight) > 0.10, ]
check_SFT(edges)
}
