% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{layoutByRecluster}
\alias{layoutByRecluster}
\title{Calculate two-level layout from recluster matrix}
\usage{
layoutByRecluster(gg, remem, layout = layout_with_kk)
}
\arguments{
\item{gg}{graph to layout}

\item{remem}{recluster result obtained by \code{\link{calcReclusterMatrix}}
invocation}

\item{layout}{one of the layout algorithms from \code{\link[igraph]{layout_}}}
}
\value{
Layout in a form of 2D matrx.
}
\description{
Takes results of recluster and apply \code{layoutByCluster} to each
}
\examples{
data(karate,package='igraphdata')
alg<-'louvain'
mem<-calcMembership(karate,alg = alg)
remem<-calcReclusterMatrix(karate,mem,alg,10)
lay<-layoutByRecluster(karate,remem)
#plot(karate,layout=lay)
}
