% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{getClustering}
\alias{getClustering}
\title{Get clustering results for the graph.}
\usage{
getClustering(
  gg,
  alg = c("lec", "wt", "fc", "infomap", "louvain", "sgG1", "sgG2", "sgG5", "spectral"),
  weights = NULL
)
}
\arguments{
\item{gg}{igraph object to cluster}

\item{alg}{clustering algorithm name}

\item{weights}{The weights of the edges. It must be a positive numeric
vector, NULL or NA. If it is NULL and the input graph has a ‘weight’
edge attribute, then that attribute will be used. If NULL and no such
attribute is present, then the edges will have equal weights. Set
this to NA if the graph was a ‘weight’ edge attribute, but you don't
want to use it for community detection. A larger edge weight means a
stronger connection for this function. The weights value is ignored
for the \code{spectral} clustering.}
}
\value{
\code{\link[igraph]{communities}} object or NULL if algorithm failed.
}
\description{
Wrapper function for calculation of clustering for predefined set of ten
algorithms:
\itemize{
\item lec -- leading eigenvector community (version of
\code{\link[igraph]{cluster_leading_eigen}}),
directed graph will be converted to undirected by
\code{\link[igraph]{as_undirected}} with mode \code{collapse};
\item wt -- walktrap community \code{\link[igraph]{cluster_walktrap}};
\item fc -- fastgreedy community \code{\link[igraph]{cluster_fast_greedy}},
directed graph will be converted to undirected by
\code{\link[igraph]{as_undirected}} with mode \code{collapse};
\item infomap -- infomap community \code{\link[igraph]{cluster_infomap}};
\item louvain -- cluster_louvain \code{\link[igraph]{cluster_louvain}},
directed graph will be converted to undirected by
\code{\link[igraph]{as_undirected}} with mode \code{collapse};
\item sgG1 -- spin-glass model and simulated annealing clustering (version of
\code{\link[igraph]{cluster_spinglass}} with spins=500 and gamma=1);
\item sgG2 -- spin-glass model and simulated annealing clustering (version of
\code{\link[igraph]{cluster_spinglass}} with spins=500 and gamma=2);
\item sgG5 -- spin-glass model and simulated annealing clustering (version of
\code{\link[igraph]{cluster_spinglass}} with spins=500 and gamma=7);
\item spectral -- spectral modularity clustering
\code{\link[rSpectral]{spectral_igraph_communities}};
}
}
\details{
graph suppose to be undirected. If algorithm failed warning will be issued
and function returned NULL.

Algorithm names are verified with \code{\link[base]{match.arg}}.
}
\examples{
data(karate,package='igraphdata')
c<-getClustering(karate,'lec')
c$modularity
}
