% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{calcMembership}
\alias{calcMembership}
\title{Calculate cluster memberships for the graph.}
\usage{
calcMembership(
  gg,
  alg = c("lec", "wt", "fc", "infomap", "louvain", "sgG1", "sgG2", "sgG5", "spectral"),
  weights = NULL
)
}
\arguments{
\item{gg}{igraph object to cluster}

\item{alg}{algorithm name}

\item{weights}{The weights of the edges. It must be a positive numeric
vector, NULL or NA. If it is NULL and the input graph has a ‘weight’
edge attribute, then that attribute will be used. If it is NULL and no such
attribute is present, then the edges will have equal weights. Set
this to NA if the graph has a ‘weight’ edge attribute, but you don't
want to use it for community detection. A larger edge weight means a
stronger connection for this function. The weights value is ignored
for the \code{spectral} clustering.}
}
\value{
data.frame with columns \code{names} and \code{membership}
}
\description{
Calculates the clustering membership for one of the 10 clustering algorithms
defined in function \code{\link{getClustering}}
}
\examples{
karate <- make_graph("Zachary")
# We need vertex ID in the 'name' attribute of the vertex
V(karate)$name<-c(LETTERS,letters)[1:vcount(karate)]
m<-calcMembership(karate, 'lec')
head(m)
}
\seealso{
getClustering
}
