% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perturbationEntropy.R
\name{calcEntropy}
\alias{calcEntropy}
\title{Calculate the graph entropy for each perturbed vertex, and save the results
as new vertex attributes in the graph.}
\usage{
calcEntropy(gg, maxSr = NULL, exVal = NULL)
}
\arguments{
\item{gg}{igraph object}

\item{maxSr}{the maximum entropy rate \eqn{maxSR}, if NULL
\code{getEntropyRate} will be called.}

\item{exVal}{expression values boundaries.
Two columns are expected: \code{xx} and \code{lambda}. If NULL
default values \code{c(2,14)} and \code{c(-14,14)} will be used
for \code{xx}  and \code{lambda} respectively.}
}
\value{
graph with SR_UP and SR_DOWN vertex attributes storing the graph
entropy values with over- or under-expressing each vertex.
}
\description{
This function calculate the graph entropy for each perturbed vertex by
calling \code{\link{getEntropy}}, and save the results as new vertex
attributes SR_UP and SR_DOWN in the graph.
}
\details{
According to Teschendorf et al., 2010, network entropy measure quantifies
the degree of randomness in the local pattern information flux around single
genes. For instance, in metastatic cancer this measure was found
significantly higher than in non-metastatic and helped to identify genes
and entire pathways involved on metastasis. However, for the assessment of
scale-free structure we do not actually require gene expression data as it
based solely on the network topology.
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.csv", package = "BioNAR")
tbl <- read.csv(file, sep="\t")
gg <- buildNetwork(tbl)
gg<-annotateGeneNames(gg)
# due to error in org.Hs.eg.db we have to manually check annotation of one node
idx <- which(V(gg)$name == '80273')
paste(V(gg)$GeneName[idx], 'GRPEL1')
gg<- calcEntropy(gg)
}
\seealso{
\code{\link[=getEntropy]{getEntropy()}}

Other Entropy Functions: 
\code{\link{getEntropy}()},
\code{\link{getEntropyRate}()},
\code{\link{plotEntropy}()}
}
\concept{Entropy Functions}
