% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateNetwork.R
\name{annotateSCHanno}
\alias{annotateSCHanno}
\title{Add SCHanno synaptic functional groups}
\usage{
annotateSCHanno(gg, anno, idatt = "name")
}
\arguments{
\item{gg}{igraph object to annotate}

\item{anno}{annotation matrix in Pairs form}

\item{idatt}{optional name of the vertex attributes that contains Entrez IDs}
}
\value{
annotated igraph object
}
\description{
The function loads an annotation data matrix of functional groups for
schizopherina risk genes (1) called anno, which contains three columns; the
first containing gene Entrez IDs, the second gene functional group ID terms,
the third gene functional group description terms. The function then performs
a many-to-one mapping of each matrix row to a network vertex using matching
Entrez IDs, filling the \code{SCHanno} vertices attribute.
}
\details{
References:
\enumerate{
\item Lips E, Cornelisse L, Toonen R, Min J, Hultman C, the International
Schizophernia Consortium, Holmans P, Donovan M, Purcell S, Smit A, Verhage M,
Sullivan P, Visscher P, D P: Functional gene group analysis identifies
synaptic gene groups as risk factor for schizophrenia.
Molecular Psychiatry 2012,17:996–1006.
}
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.csv", package = "BioNAR")
tbl <- read.csv(file, sep="\t")
gg <- buildNetwork(tbl)
afile<-system.file("extdata", "SCH_flatfile.csv", package = "BioNAR")
dis    <- read.table(afile, sep="\t", skip=1, header=FALSE,
strip.white=TRUE, quote="")
agg<-annotateSCHanno(gg, dis)
}
\seealso{
getAnnotationVertexList
}
