% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliar.R
\name{removeDup}
\alias{removeDup}
\title{Remove duplicated rows and columns}
\usage{
removeDup(cor_mat, dupli)
}
\arguments{
\item{cor_mat}{List of matrices}

\item{dupli}{List of indices with duplicated entries}
}
\value{
A matrix with only one of the columns and rows duplicated
}
\description{
Given the indices of the duplicated entries remove the columns and rows
until just one is left, it keeps the duplicated with the highest absolute
mean value.
}
\examples{
a <- seq2mat(c("52", "52", "53", "55"), runif(choose(4, 2)))
b <- seq2mat(c("52", "52", "53", "55"), runif(choose(4, 2)))
mat <- list("kegg" = a, "react" = b)
mat
dupli <- duplicateIndices(rownames(a))
remat <- removeDup(mat, dupli)
remat
}
\seealso{
\code{\link[=duplicateIndices]{duplicateIndices()}} to obtain the list of indices with
duplicated entries.
}
\author{
Lluís Revilla
}
