% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_data}
\alias{plot_data}
\alias{plot_similarity}
\title{The position of the nodes is based on the similarity between them.}
\usage{
plot_data(x, top)

plot_similarity(pd)
}
\arguments{
\item{x}{Matrix with the similarities.}

\item{top}{a number between 0 and 1 to select the edges relating the elements of the matrix.}

\item{pd}{The plot data from \code{plot_data()} function.}
}
\value{
A list with two elements:
\itemize{
\item nodes: The position and name of the nodes
\item edges: The information about the selected edges
}

A ggplot object
}
\description{
The position of the nodes is based on the similarity between them.

Plot how similar are the data
}
\examples{
if (require("org.Hs.eg.db") & require("reactome.db")) {
  # Extract the paths of all genes of org.Hs.eg.db from KEGG
  # (last update in data of June 31st 2011)
  genes.kegg <- as.list(org.Hs.egPATH)
  # Extracts the paths of all genes of org.Hs.eg.db from reactome
  genes.react <- as.list(reactomeEXTID2PATHID)

  sim <- mgeneSim(c("87", "18", "10"), genes.react)
  pd <- plot_data(sim, top = 0.25)
  if (requireNamespace("ggplot2", quietly = TRUE)){
    plot_similarity(pd)
  }
}
}
