% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIntegratedCalls.R
\name{getIntegratedCalls}
\alias{getIntegratedCalls}
\title{Retrieve Bgee calls from one species.}
\usage{
getIntegratedCalls(
  myBgeeObject,
  conditionParameters = "anatEntity",
  advancedColumns = FALSE,
  geneIds = NULL,
  anatEntityIds = NULL
)
}
\arguments{
\item{myBgeeObject}{A Reference Class Bgee object, notably specifying the targeted species
and data type.}

\item{conditionParameters}{Specify which condition parameter you are interested
in. It can be \code{anatEntity} or \code{allCondParams}. The \code{anatEntity} option retrieve calls generated
using only anatomical entity and cell-type as a condition parameter. The \code{allCondParams} option retrieve calls generated taking
into consideration all condition parameters present in Bgee (anat, entity, cell-type, developmental stage,
sex and strain). By default the \code{anatEntity} option is selected.}

\item{advancedColumns}{Boolean allowing to specify if advancend columns are required. The default value
is \code{FALSE} meaning that only gene , condition parameters, call quality, FDR, expression rank and
expression score are retrieved. If \code{TRUE} then a lot more information used to generate the calls are
retrieved like the number of self and descendant observation for each datatype, or the rank and score
per datatype.}

\item{geneIds}{List of genes for which expression calls have to be retrieved. It has to be ensembl
IDs if the Bgee genome source is Ensembl (e.g ENSG00000244734) or RefSeq IDs if the Bgee genome source
is RefSeq (e.g 734881) but not gene names (e.g HBB, Apoc1, etc.).}

\item{anatEntityIds}{List of anatomical entity IDs for which expression calls have to be retrieved.
It has to be IDs (e.g UBERON:0000955) and not names (e.g brain)}
}
\value{
Return a data.table containing all calls from the specified species
}
\description{
This function loads the integrated expression calls from one species. These calls are
equivalent to the one provided in the gene page of the Bgee website. The calls have been
generated using all datatypes present in Bgee (EST, In Situ, Affymetrix, bulk RNA-Seq and
single-cell RNA-Seq).
}
\examples{
{
  bgee <- Bgee$new(species = "Danio_rerio")
  callsHer1 <- getIntegratedCalls(bgee, geneIds="ENSDARG00000014722")
}

}
\author{
Julien Wollbrett
}
