% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bgee.R
\docType{class}
\name{Bgee-class}
\alias{Bgee-class}
\alias{Bgee}
\title{Bgee Reference Class}
\description{
This is used to specify information at the beginning of a BgeeDB working session, for example, the targeted species and data type. An object of this class is then passed as argument to other functions of the package to provide these informations. See examples in vignette.
}
\details{
Bgee (\url{https://www.bgee.org}) integrates different expression data types (RNA-seq, Affymetrix microarray, ESTs, and in-situ hybridizations) from multiple animal species. Expression patterns are based exclusively on curated "normal", healthy, expression data (e.g., no gene knock-out, no treatment, no disease), to provide a reference atlas of normal gene expression.
}
\section{Fields}{

\describe{
\item{\code{dataType}}{A vector of characters indicating data type(s) to be used. To be chosen among:
\itemize{
\item{"rna_seq: target only bulk RNA-seq data"}
\item{"sc_full_length: target only full length single-cell RNA-seq data"}
\item{"sc_droplet_based: target only droplet based single-cell RNA-seq data"}
\item{"affymetrix: target only Affymtrix microarray data"}
\item{"est: target only ESTs data"}
\item{"in_situ: target only In Situ data"}
}
By default all data type are included: \code{c("rna_seq","sc_full_length","sc_droplet_based","affymetrix","est","in_situ")}. For download of quantitative expression data, a single data type should be chosen among "rna_seq", "sc_full_length", sc_droplet_based" or "affymetrix".}

\item{\code{pathToData}}{Path to the directory where the data files are stored. By default the working directory is used. If many analyses are launched in parallel, please consider re-using the cached data files instead of redownlaoding them for each analysis.}

\item{\code{release}}{Bgee release number to download data from, in the form "Release.subrelease" or "Release_subrelease", e.g., "15.2" or 15_2". Work for release >=13.2. By default, the latest relase of Bgee is used.}

\item{\code{sendStats}}{A field specifying whether monitoring of users is performed for our internal usage statistics. This is useful to improve the settings of our servers and to get reliable usage statistics (e.g., when asking for funding for Bgee). No identification of the users is attempted, nor possible. Default to TRUE. This option can be set to FALSE, notably if all data files are in cache and that users want to be able to work offline.}

\item{\code{quantitativeData}}{A field specifying if a single type of quantitative expression data ("rna_seq", "sc_full_length", "sc_droplet_based" or "affymetrix") was specified and if it is available for targeted species, helping the package to know if it should proceed with the execution of getAnnotation() and getData() functions.}
}}


\examples{
{
 bgee <- Bgee$new(species = "Mus_musculus", dataType = "rna_seq")
 bgee <- Bgee$new(species = "Mus_musculus")
}

}
