% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presenceAbsence.R
\name{generate_presence_absence}
\alias{generate_presence_absence}
\title{Generate presence absence}
\usage{
generate_presence_absence(
  myAbundanceMetadata = new("KallistoMetadata"),
  myBgeeMetadata = new("BgeeMetadata"),
  myUserMetadata,
  pvalueCorrection = "None"
)
}
\arguments{
\item{myAbundanceMetadata}{A descendant object of the Class myAbundanceMetadata
(optional).}

\item{myBgeeMetadata}{A Class BgeeMetadata object (optional).}

\item{myUserMetadata}{A Class UserMetadata object.}

\item{pvalueCorrection}{A string indicating the method to use to correct the pValue.}
}
\value{
path to the 4 output files
}
\description{
Generate presence absence calls. It correponds to 
the last part of the generation of the expression calls workflow. 
It runs the last part of the workflow generating present/absent 
expression calls. 
This function should only be used by advanced user who already 
manually run all previous parts of the pipeline.
If you are not an advanced user it is safer to run the function 
``generate_calls_workflow`` that run all steps of the worklow
}
\examples{
{
# this example reuse data present in the directory 'extdata' of the package.
user <- new('UserMetadata', working_path = system.file('extdata', 
package = 'BgeeCall'), species_id = '6239', rnaseq_lib_path = system.file(
'extdata', 'SRX099901_subset', package = 'BgeeCall'), 
annotation_name = 'WBcel235_84', simple_arborescence = TRUE)
calls_output <- generate_presence_absence(myUserMetadata = user)

#
}

}
\seealso{
generate_calls_workflow
}
\author{
Julien Wollbrett

Julien Roux

Sara Fonseca Costa

Alessandro Brandulas Cammarata
}
