% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_statistic.R
\name{is_design_balanced}
\alias{is_design_balanced}
\title{Check if the experimental design is balanced or unbalanced}
\usage{
is_design_balanced(se, batch, covariate)
}
\arguments{
\item{se}{summarized experiment object}

\item{batch}{string, batch variable}

\item{covariate}{string, biological covariate}
}
\value{
Boolean Value, TRUE if the experimental design is balanced, FALSE if
the experimental design is not balanced
}
\description{
Used in conjunction with the lambda
}
\examples{

library(scran)
se <- mockSCE()
balanced_design_check <- is_design_balanced(se, batch = "Mutation_Status",
                                                covariate = "Treatment")
balanced_design_check

}
