% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negative_binomial_check.R
\name{DESeq2_small_size}
\alias{DESeq2_small_size}
\title{This function calculated the goodness of fit of DESeq2 for small sample sizes
(intended for less than 20 samples).}
\usage{
DESeq2_small_size(
  count_matrix,
  condition,
  other_variables,
  conditions_df,
  formula_for_DESeq,
  num_samples
)
}
\arguments{
\item{count_matrix}{matrix containing the data to be analyzed}

\item{condition}{a vector containing a factor of the condition of interest
(typically batch)}

\item{other_variables}{a vector of strings of other variables of interest}

\item{conditions_df}{data frame containing information for the other
variables of interest (columns in order of the other_variables vector)}

\item{formula_for_DESeq}{the stat formula to be used in the DESeq analysis}

\item{num_samples}{total number of samples to analyze}
}
\value{
a list containing the string recommendation, the histogram and a
reference for the original source of the test
}
\description{
This function calculated the goodness of fit of DESeq2 for small sample sizes
(intended for less than 20 samples).
}
