% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduction.R
\name{runBanksyUMAP}
\alias{runBanksyUMAP}
\title{Run UMAP on a BANKSY embedding.}
\usage{
runBanksyUMAP(
  se,
  use_agf = FALSE,
  lambda = 0.2,
  use_pcs = TRUE,
  npcs = 20L,
  dimred = NULL,
  ndims = NULL,
  assay_name = NULL,
  scale = TRUE,
  group = NULL,
  n_neighbors = 30L,
  spread = 3,
  min_dist = 0.1,
  n_epochs = 300L,
  M = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{se}{A \code{SpatialExperiment},
\code{SingleCellExperiment} or \code{SummarizedExperiment}
  object with \code{computeBanksy} ran.}

\item{use_agf}{A logical vector specifying whether to use the AGF for
computing UMAP.}

\item{lambda}{A numeric vector in \eqn{\in [0,1]} specifying a spatial
weighting parameter. Larger values (e.g. 0.8) incorporate more spatial
neighborhood and find spatial domains, while smaller values (e.g. 0.2)
perform spatial cell-typing.}

\item{use_pcs}{A logical scalar specifying whether to run UMAP on PCs. If
FALSE, runs on the BANKSY matrix.}

\item{npcs}{An integer scalar specifying the number of principal components
to use if \code{use_pcs} is TRUE.}

\item{dimred}{A string scalar specifying the name of an existing
dimensionality reduction result to use. Will overwrite \code{use_pcs} if
supplied.}

\item{ndims}{An integer scalar specifying the number of dimensions to use if
\code{dimred} is supplied.}

\item{assay_name}{A string scalar specifying the name of the assay used in
\code{computeBanksy}.}

\item{scale}{A logical scalar specifying whether to scale features before
UMAP. Only used when use_pcs is FALSE. Defaults to TRUE.}

\item{group}{A string scalar specifying a grouping variable for samples in
\code{se}. This is used to scale the samples in each group separately.}

\item{n_neighbors}{An integer scalar specifying the number of neighbors to
use for UMAP.}

\item{spread}{A numeric scalar specifying the effective scale of embedded
points.}

\item{min_dist}{A numeric scalar specifying the effective min. dist. between
embedded points.}

\item{n_epochs}{An integer scalar specifying the number of epochs to run
UMAP optimization.}

\item{M}{Advanced usage. An integer vector specifying the highest azimuthal
Fourier harmonic to use. If specified, overwrites the \code{use_agf}
argument.}

\item{seed}{Seed for UMAP. If not specified, no seed is set.}

\item{...}{parameters to pass to uwot::umap}
}
\value{
A SpatialExperiment / SingleCellExperiment / SummarizedExperiment
  object with UMAP coordinates in \code{reducedDims(se)}.
}
\description{
Run UMAP on a BANKSY embedding.
}
\details{
This function runs UMAP on the principal components computed on the 
BANKSY matrix.
}
\examples{
data(rings)
spe <- computeBanksy(rings, assay_name = "counts", M = 1, k_geom = c(15, 30))
spe <- runBanksyPCA(spe, M = 1, lambda = 0.2, npcs = 20)
spe <- runBanksyUMAP(spe, M = 1, lambda = 0.2)

}
