% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaalChIP-generics.R, R/BaalChIP-methods.R
\name{BaalChIP.get}
\alias{BaalChIP.get}
\alias{BaalChIP.get,BaalChIP-method}
\title{Method BaalChIP.get}
\usage{
BaalChIP.get(
  .Object,
  what = c("samples", "param", "alleleCountsPerBam", "mergedCounts", "assayedVar",
    "biasTable")
)

\S4method{BaalChIP.get}{BaalChIP}(
  .Object,
  what = c("samples", "param", "alleleCountsPerBam", "mergedCounts", "assayedVar")
)
}
\arguments{
\item{.Object}{An object of the \code{\link{BaalChIP}} class.}

\item{what}{a single character value specifying which information should be retrieved. Options: 'samples', 'param', 'alleleCountsPerBam', 'mergedCounts', 'assayedVar', 'biasTable'.}
}
\value{
The slot content from an object of the \code{\link{BaalChIP}} class.
}
\description{
Get information from individual slots in a BaalChIP object.
}
\examples{
data('BaalObject')

#samples data spreadsheet and hets:
BaalChIP.get(BaalObject,what='samples')

#parameters used within run:
BaalChIP.get(BaalObject,what='param')

#retrieve a GRanges list with allele-specific read counts per BAM file:
counts <- BaalChIP.get(BaalObject,what='alleleCountsPerBam')
counts[['MCF7']][[1]]

#retrieve a data.frame with allele-specific read counts per group:
counts <- BaalChIP.get(BaalObject,what='mergedCounts')
head(counts[[1]])
}
\author{
Ines de Santiago
}
