% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocity.R
\name{check_genome}
\alias{check_genome}
\title{Check for chromosomes in genome but not annotation}
\usage{
check_genome(chrs_use, Genome)
}
\arguments{
\item{chrs_use}{Character vector of names of chromosomes present in both the
annotation and the genome.}

\item{Genome}{Either a \code{\link{BSgenome}} or a \code{\link{XStringSet}}
object of genomic sequences, where the intronic sequences will be extracted
from. Use \code{\link{genomeStyles}} to check which styles are supported for
your organism of interest; supported styles can be interconverted. If the
style in your genome or annotation is not supported, then the style of
chromosome names in the genome and annotation should be manually set to be
consistent.}
}
\value{
Nothing. Will emit message if the genome contains chromosomes absent
from the annotation.
}
\description{
Check for chromosomes in genome but not annotation
}
