% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_process_functions.R
\name{read_rna_encode_caltech}
\alias{read_rna_encode_caltech}
\title{(DEPRECATED) Read ENCODE Caltech bed formatted RNA-Seq file}
\usage{
read_rna_encode_caltech(file, chr_discarded = NULL, is_GRanges = TRUE)
}
\arguments{
\item{file}{The name of the file to read data values from.}

\item{chr_discarded}{A vector with chromosome names to be discarded.}

\item{is_GRanges}{Logical: if TRUE a GRanges object is returned, otherwise a
data.frame object is returned.}
}
\value{
A \code{GRanges} object if \code{is_GRanges} is TRUE, otherwise a
  \code{data.table} object.

  The GRanges object contains three additional metadata columns: \itemize{
  \item \code{ensembl_id}: Ensembl IDs of each gene promoter. \item
  \code{gene_name}: Gene name. \item \code{gene_fpkm}: Expression level in
  FPKM. } These columns can be accessed as follows:
  \code{granges_object$ensembl_id}
}
\description{
(DEPRECATED) \code{read_rna_encode_caltech} reads a file
  containing promoter annotation data together with gene expression levels
  from RNA-Seq experiments using the \code{\link{scan}} function. The RNA-Seq
  file should be in ENCODE Caltech \code{bed} format, e.g. use \code{gtf2bed}
  tool if your initial file is in \code{gtf} format.
}
\examples{
# Obtain the path to the file and then read it
rnaseq_file <- system.file("extdata", "rnaseq.bed", package = "BPRMeth")
rna_data <- read_rna_encode_caltech(rnaseq_file)

}
\seealso{
\code{\link{read_chrom_size}}, \code{\link{read_bs_encode_haib}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
