% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{read_met}
\alias{read_met}
\title{Read methylation file}
\usage{
read_met(
  file,
  type = "sc_seq",
  strand_info = FALSE,
  chr_discarded = NULL,
  min_bulk_cov = 4,
  max_bulk_cov = 1000,
  delimiter = "\\t"
)
}
\arguments{
\item{file}{File name.}

\item{type}{Type of technology as character. Either "bulk_seq", "sc_seq" or
"array". Check the Important section below for more details.}

\item{strand_info}{Logical, whether or not the file contains strand
information.}

\item{chr_discarded}{Optional vector with chromosomes to be discarded.}

\item{min_bulk_cov}{Minimum number of reads mapping to each CpG site. Used
only for "bulk_seq" and CpGs with less reads will be discarded as noise.}

\item{max_bulk_cov}{Maximum number of reads mapping to each CpG site. Used
only for "bulk_seq" and CpGs with less reads will be discarded as noise.}

\item{delimiter}{Delimiter format the columns are splitted. Default is tab.}
}
\value{
A \code{GRanges} object.

  The GRanges object contains one or two additional metadata columns:
  \itemize{ \item{ \code{met}: Methylation level. \itemize{ \item{For "array"
  this is the Beta or M-values} \item{For "sc_seq" this is either 0 or 1
  (unmethylated or methylated)} \item{For "bulk_seq" this contains the number
  of methylated reads for each CpG.} } }  \item{ \code{total}: Total number
  of reads for each CpG. Present only for "bulk_seq" type. } } These columns
  can be accessed as follows: \code{granges_obj$met}
}
\description{
\code{read_met} reads a file containing methylation data using
  the \code{fread} function. Since there are different technologies, e.g.
  array, bulk BS-Seq, scBS-Seq, and still there is no standard file format,
  different options are available, check the Important section below on the
  file format for each type you choose. If a file format is not availabe, you
  need to read the file and create a \code{GRanges} object, where the data
  are ordered by chromosome and genomic location.
}
\section{Important}{
 Depending on technology \code{type} we assume different
  file formats. \itemize{ \item{ \code{"array"} File format: "chromosome",
  "start", "strand" (optional), "met" .} \item{ \code{"sc_seq"} File format:
  "chromosome", "start", "strand" (optional), "met" . Where "met" should
  contain only 1s or 0s. } \item{ \code{"bulk_seq"} File format:
  "chromosome", "start", "strand" (optional), "met", "total". } } By default
  columns are considered in tab delimited format.
}

\examples{
# Obtain the path to files
file <- system.file("extdata", "dummy_met.bed", package = "BPRMeth")
met_dt <- read_met(file)

# Extract methylation level
met <- met_dt$met

}
\seealso{
\code{\link{read_anno}}, \code{\link{read_expr}},
  \code{\link{create_region_object}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
