% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{read_chrom_size}
\alias{read_chrom_size}
\title{Read genome chromosome sizes file}
\usage{
read_chrom_size(file, delimiter = "\\t")
}
\arguments{
\item{file}{File name}

\item{delimiter}{Delimiter format the columns are splitted. Default is tab.}
}
\value{
A \code{\link[data.table]{data.table}} object.
}
\description{
\code{read_chrom_size} reads a file containing genome chromosome
  sizes using the \code{\link[data.table]{fread}} function.
}
\examples{
chr_file <- system.file("extdata", "hg19.chr.sizes", package = "BPRMeth")
chr_data <- read_chrom_size(chr_file)

# Extract the size of chr1
chr_data[1]

}
\seealso{
\code{\link{read_met}}, \code{\link{read_anno}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
