% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_process_functions.R
\name{preprocess_bs_seq}
\alias{preprocess_bs_seq}
\title{(DEPRECATED) Pre-process BS-Seq data in any given format}
\usage{
preprocess_bs_seq(
  files,
  file_format = "encode_rrbs",
  chr_discarded = NULL,
  min_bs_cov = 4,
  max_bs_cov = 1000
)
}
\arguments{
\item{files}{A vector of filenames containing replicate experiments. This can
also be just a single replicate.}

\item{file_format}{A string denoting the file format that the BS-Seq data are
stored. Current version allows "\code{encode_rrbs}" or "\code{bismark_cov}"
formats.}

\item{chr_discarded}{A vector with chromosome names to be discarded.}

\item{min_bs_cov}{The minimum number of reads mapping to each CpG site. CpGs
with less reads will be considered as noise and will be discarded.}

\item{max_bs_cov}{The maximum number of reads mapping to each CpG site. CpGs
with more reads will be considered as noise and will be discarded.}
}
\value{
A \code{GRanges} object. The GRanges object contains two additional
  metadata columns: \itemize{ \item \code{total_reads}: total reads mapped to
  each genomic location. \item \code{meth_reads}: methylated reads mapped to
  each genomic location. } These columns can be accessed as follows:
  \code{granges_object$total_reads}
}
\description{
(DEPRECATED) \code{preprocess_bs_seq} is a general function for
  reading and preprocessing BS-Seq data. If a vector of files is given, these
  are considered as replicates and are pooled together. Finally, noisy reads
  are discarded.
}
\section{Additional Info}{
 Information about the file formats can be found in
  the following links:

  Encode RRBS format:
  \url{http://rohsdb.cmb.usc.edu/GBshape/cgi-bin/hgTables?db=
  hg19&hgta_group=regulation&hgta_track=wgEncodeHaibMethylRrbs&hgta_table=
  wgEncodeHaibMethylRrbsBcbreast0203015BiochainSitesRep2&hgta_doSchema=
  describe+table+schema}

  Bismark Cov format: \url{http://rnbeads.mpi-inf.mpg.de/data/RnBeads.pdf}
}

\examples{
# Obtain the path to the files
bs_file <- system.file("extdata", "rrbs.bed", package = "BPRMeth")
bs_data <- preprocess_bs_seq(bs_file, file_format = "encode_rrbs")

}
\seealso{
\code{\link{read_bs_encode_haib}} \code{\link{pool_bs_seq_rep}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
