% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_expr.R
\name{predict_expr}
\alias{predict_expr}
\title{Predict gene expression from methylation profiles}
\usage{
predict_expr(
  formula = NULL,
  prof_obj,
  expr,
  anno,
  model_name = "lm",
  train_ind = NULL,
  train_perc = 0.7,
  fit_feature = "RMSE",
  cov_feature = TRUE,
  is_summary = TRUE
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats]{formula}}, e.g. see
\code{\link[stats]{lm}} function. If NULL, the simple linear regression
model is used.}

\item{prof_obj}{Inferred profiles object. This in general will be the output
of 'infer_profiles_'(inference_meth) function.}

\item{expr}{Gene expression data with two columns in \code{data.frame} or
\code{data.table} format. 1st column will have gene IDs and should have
column name "id", 2nd column will have expression levels.}

\item{anno}{Annotation data as a \code{GRanges} object.}

\item{model_name}{A string denoting the regression model. Currently,
available models are: \code{"svm"}, \code{"randomForest"}, \code{"rlm"},
\code{"mars"}, \code{"gp"}, and \code{"lm"}.}

\item{train_ind}{Optional vector containing the indices for the train set.}

\item{train_perc}{Optional parameter for defining the percentage of the
dataset to be used for training set, the remaining will be the test set.}

\item{fit_feature}{Use additional feature of how well the profile fits the
methylation data. Either NULL for ignoring this feature or one of the
following: 1) "RMSE" or 2) "NLL" which will be used as input features for
predicting expression.}

\item{cov_feature}{Logical, whether to use coverage as input feature for
predictions.}

\item{is_summary}{Logical, print the summary statistics.}
}
\value{
A 'predict_expr' object which consists of the following variables:
  \itemize{ \item{train}: The training data. \item{test}: The test data.
  \item \code{model}: The fitted regression model. \item \code{train_pred}
  The predicted values for the training data. \item \code{test_pred} The
  predicted values for the test data. \item \code{train_errors}: The training
  error metrics. \item \code{test_errors}: The test error metrics.}
}
\description{
\code{bpr_predict_wrap} is a function that wraps all the
  necessary subroutines for performing prediction on gene expression levels.
  Initially, it optimizes the parameters of the basis functions so as to
  learn the methylation profiles. Then, uses the learned parameters /
  coefficients of the basis functions as input features for performing
  regression in order to predict the corresponding gene expression levels.
}
\examples{
# Fit methylation profiles using 5 RBFs
basis <- create_rbf_object(M = 5)
prof <- infer_profiles_vb(X = encode_met$met, model = "binomial",
    basis = basis, is_parallel = FALSE, vb_max_iter = 5)
# Predict expression
pred_obj <- predict_expr(prof_obj = prof, expr = encode_expr,
  anno = encode_met$anno, model_name = "lm", is_summary = FALSE)

}
\seealso{
\code{\link{infer_profiles_mle}}, \code{\link{infer_profiles_vb}},
  \code{\link{infer_profiles_gibbs}}, \code{\link{create_basis}},
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
