% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_process_functions.R
\name{pool_bs_seq_rep}
\alias{pool_bs_seq_rep}
\title{(DEPRECATED) Read and pool replicates from BS-Seq data}
\usage{
pool_bs_seq_rep(files, file_format = "encode_rrbs", chr_discarded = NULL)
}
\arguments{
\item{files}{A vector of filenames containing replicate experiments. This can
also be just a single replicate.}

\item{file_format}{A string denoting the file format that the BS-Seq data are
stored. Current version allows "\code{encode_rrbs}" or "\code{bismark_cov}"
formats.}

\item{chr_discarded}{A vector with chromosome names to be discarded.}
}
\value{
A \code{GRanges} object. The GRanges object contains two additional
  metadata columns: \itemize{ \item \code{total_reads}: total reads mapped to
  each genomic location. \item \code{meth_reads}: methylated reads mapped to
  each genomic location. } These columns can be accessed as follows:
  granges_object$total_reads
}
\description{
(DEPRECATED) \code{pool_bs_seq_rep} reads and pools replicate
  methylation data from BS-Seq experiments that are either in Encode RRBS or
  Bismark Cov format. Read the Important section below on when to use this
  function.
}
\section{Important}{
 Unless you want to create a different workflow when
  processing the BS-Seq data, you should NOT call this function, since this
  is a helper function. Instead you should call the
  \code{\link{preprocess_bs_seq}} function.

  Information about the file formats can be found in the following links:

  Encode RRBS format:
  \url{http://rohsdb.cmb.usc.edu/GBshape/cgi-bin/hgTables?db=hg19&hgta_group=
  regulation&hgta_track=wgEncodeHaibMethylRrbs&hgta_table=
  wgEncodeHaibMethylRrbsBcbreast0203015BiochainSitesRep2&hgta_doSchema=
  describe+table+schema}

  Bismark Cov format: \url{http://rnbeads.mpi-inf.mpg.de/data/RnBeads.pdf}
}

\examples{
# Obtain the path to the file
bs_file1 <- system.file("extdata", "rrbs.bed", package = "BPRMeth")
bs_file2 <- system.file("extdata", "rrbs.bed", package = "BPRMeth")

# Concatenate the files
bs_files <-  c(bs_file1, bs_file2)
# Pool the replicates
pooled_data <- pool_bs_seq_rep(bs_files)

}
\seealso{
\code{\link{read_bs_encode_haib}}, \code{\link{preprocess_bs_seq}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
